VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "TextStream"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'================================================================================
' Class Name:
'      Text Stream
'
' Instancing:
'      Private; Internal  (VB Setting: 1 - Private)
'
' Purpose:
'       This class is used to create a very basic version of the stream object that
'       exists in the C++ programming language. Using streams, the programmer can read
'       data from any number of sources while masking this from the code using the
'       stream. Visual Basic .NET will add this functionality.
'
' Revisions:
'       Version 2: The OpenFile function returns a boolean. The err code is stored into
'       a temporary variable
'
' Author(s):
'      Devin Cook
'
' Dependacies:
'      (None)
'
'================================================================================
Option Explicit

Public Enum StreamCharTypeConstants
   StreamCharTypeASCII = 1
   StreamCharTypeUnicodeLE = 2     '== Little Endian: For those x86 guys
   StreamCharTypeUnicodeBE = 3     '== Big Endian   : For those Motorola guys
End Enum

Private Enum StreamTargetConstants
   StreamTargetString = 1
   StreamTargetFile = 2
End Enum

Public Enum StreamFileModeConstants
   StreamFileModeRead = 1
   StreamFileModeWrite = 2
   StreamFileModeAppend = 3
End Enum

Private m_FileNumber As Integer
Private m_IsFileOpen As Boolean

'========= The main data type and control
Private m_Buffer As String             'Up to 2 billion chars

Private m_StreamTarget As StreamTargetConstants

'== These are separate because a future expansion of this
'== class may permit data to be read and written. A possible
'== example includes a socket

Private m_StreamCanWrite As Boolean
Private m_StreamCanRead As Boolean

'=== Private Properties - shared through public functions

Private m_CharType  As StreamCharTypeConstants

Private m_ErrCode As Long

Public Property Get CharType() As StreamCharTypeConstants
    CharType = m_CharType
End Property

Public Property Let CharType(ByVal Value As StreamCharTypeConstants)
    m_CharType = Value
End Property
Private Sub CloseStream()
 
   If m_StreamTarget = StreamTargetFile And m_IsFileOpen Then
       Close m_FileNumber
       m_IsFileOpen = False
   End If
   
End Sub

Public Function EOF() As Boolean
    Dim Result As Boolean

    Select Case m_StreamTarget
        Case StreamTargetString
            Result = (Len(m_Buffer) = 0)
        
        Case StreamTargetFile
            If Not m_IsFileOpen Then
                Result = True
            ElseIf Seek(m_FileNumber) > LOF(m_FileNumber) Then
                Result = True
            Else
                Result = False
            End If
    End Select
    
    EOF = Result
End Function

Public Function ErrorCode() As Long
    ErrorCode = m_ErrCode
End Function

Public Function ErrorText() As String
    ErrorText = Error(m_ErrCode)
End Function
Private Function InputByte() As Byte
    'Visual Basic's IO features are primative. The language does
    'not contain a fucntion to read a byte from a file!
    On Error Resume Next
    Dim Value As Byte
    
    Get #m_FileNumber, , Value
       
    InputByte = Value
       
    'InputByte = AscB(InputB(1, FileNumber))
End Function

Private Function OutputByte(Value As Byte)
    On Error Resume Next
       
    Put #m_FileNumber, , Value
End Function
Public Function IsFileOpen() As Boolean
   IsFileOpen = m_IsFileOpen

End Function


Public Sub CloseFile()

   If m_IsFileOpen Then
       CloseStream
   End If

End Sub



Public Function OpenFile( _
    ByVal FileName As String, _
    ByVal Mode As StreamFileModeConstants, _
    Optional ByVal CharType As StreamCharTypeConstants = StreamCharTypeASCII, _
    Optional ByVal UseByteOrderMarks As Boolean = True) As Boolean
    
    On Error Resume Next
    Dim n As Long
    Dim BOM1 As Byte, BOM2 As Byte
    Dim FileExists, Result As Long
      
    '=== BOM: FE FF for big-endian, FF FE for little-endian
   
    If m_IsFileOpen Then
        Close m_FileNumber
    End If
   
    m_StreamCanRead = False
    m_StreamCanWrite = False
    m_IsFileOpen = False
    
    '==== Check if file exists
    FileExists = (Dir(FileName) <> "")
    
    Select Case Mode
        Case StreamFileModeWrite
            '=== If the file exists, it must be deleted
            If FileExists Then
                Kill FileName
            End If
            
            m_FileNumber = FreeFile
            Open FileName For Binary Access Write As m_FileNumber
    
            If Err.Number = 0 Then
                m_IsFileOpen = True
                m_StreamTarget = StreamTargetFile
                m_StreamCanWrite = True
                m_CharType = CharType
                                        
                If UseByteOrderMarks Then
                    Select Case m_CharType
                        Case StreamCharTypeUnicodeBE
                            OutputByte &HFE
                            OutputByte &HFF
                        Case StreamCharTypeUnicodeLE
                            OutputByte &HFF
                            OutputByte &HFE
                    End Select
                End If
                
                Result = 0
            Else
                Result = Err.Number
                Err.Clear
            End If
            
        Case StreamFileModeRead
            If FileExists Then
                m_FileNumber = FreeFile
                Open FileName For Binary Access Read As m_FileNumber
             
                If Err.Number = 0 Then
                    m_IsFileOpen = True
                    m_StreamTarget = StreamTargetFile
                    m_StreamCanRead = True
                
                    '=== Setup endianess, etc.. information
                    If UseByteOrderMarks And LOF(m_FileNumber) >= 2 Then
                        BOM1 = InputByte()
                        BOM2 = InputByte()
                        
                        If (BOM1 = &HFE) And (BOM2 = &HFF) Then
                            m_CharType = StreamCharTypeUnicodeBE
                        ElseIf (BOM1 = &HFF) And (BOM2 = &HFE) Then
                            m_CharType = StreamCharTypeUnicodeLE
                        Else
                            Seek m_FileNumber, 1                'Rewind. Treat this file was ASCII
                            m_CharType = StreamCharTypeASCII
                        End If
                    End If
                Else
                    Result = Err.Number
                    Err.Clear
                End If
            Else
                Result = 53  'File not found
            End If
            
        Case StreamFileModeAppend
            m_FileNumber = FreeFile
            Open FileName For Binary Access Write As m_FileNumber
            
            If Err.Number = 0 Then
                m_IsFileOpen = True
                m_StreamTarget = StreamTargetFile
                m_StreamCanWrite = True
                m_CharType = CharType
                
                Seek m_FileNumber, LOF(m_FileNumber) + 1 'Advance to end
            Else
                Result = Err.Number
                Err.Clear
            End If
    End Select

    m_ErrCode = Result
    OpenFile = (Result = 0)
End Function



Public Function ReadText(Optional ByVal Length As Integer = 1) As String
    'This function reads the appropiate amount of characters from the
    'buffer and constucts the requested datatype
    
    If m_StreamCanRead Then
        ReadText = StreamRead(Length)
    Else
        ReadText = ""
    End If

End Function


Public Sub WriteText(Text As String)
    If m_StreamCanWrite Then
        StreamWrite Text
    End If
End Sub







Public Sub WriteLine(Optional Text As String = "")
    If m_StreamCanWrite Then
        StreamWrite Text & vbNewLine
    End If
End Sub

Private Function StreamRead(ByVal CharCount As Integer) As String

    'This function takes data from the buffer and creates a string of the
    'appropiate size.
      
    Dim StreamLeft As Long, Result As String
    Dim Needed As Long
    
    Select Case m_StreamTarget
        Case StreamTargetFile
            Result = FileReadChars(CharCount)
        
        Case StreamTargetString
            If CharCount > Len(m_Buffer) Then
                Result = m_Buffer    'Rest of Buffer
                m_Buffer = ""
            Else
                Result = Left(m_Buffer, CharCount)
                m_Buffer = Mid(m_Buffer, CharCount + 1)      'Remove the read chars
            End If
    End Select
        
    StreamRead = Result
End Function


Private Sub StreamWrite(ByVal Text As String)
    'This is the sub that adds info to the buffer and then
    'flushes it if necessary.
    'Dim n As Integer
    
    Select Case m_StreamTarget
        Case StreamTargetFile
            If m_IsFileOpen And m_StreamCanWrite Then
                FileWriteChars Text
            End If
        
        Case StreamTargetString
            m_Buffer = m_Buffer & Text
    End Select
End Sub
Private Function FileReadChars(ByVal Count As Long, Optional Advance As Boolean = True) As String
    'This function reads a single character from the File. This can be either 1 or 2 bytes
    'depending on whether ASCII or Unicode is used.
        
    Dim BytesLeft As Long, Result As String, CharsLeft As Long
    Dim B1 As Byte, B2 As Byte, n As Long, Char As String
    Dim OrigPos As Long
        
    Result = ""
    
    If m_IsFileOpen Then
        '==========================
        'The total bytes left
        '==========================
        If VBA.EOF(m_FileNumber) Then
            BytesLeft = 0
        Else
            BytesLeft = LOF(m_FileNumber) - Seek(m_FileNumber) + 1
        End If
                   
                       
        '==========================
        'Get the original position to rewind
        '==========================
        OrigPos = Seek(m_FileNumber)
                           
        '==========================
        'Read from the file
        '==========================
        Select Case m_CharType
            Case StreamCharTypeUnicodeLE         'Little Endian - Intel
                CharsLeft = BytesLeft / 2
                n = 1
                Do While (n <= CharsLeft) And (n <= Count)
                    B1 = InputByte()
                    B2 = InputByte()
                    Result = Result & ChrW(ConstructInt16(B2, B1))
                    n = n + 1
                Loop
                
            Case StreamCharTypeUnicodeBE         'Big Endian - Motorola
                CharsLeft = BytesLeft / 2
                n = 1
                Do While (n <= CharsLeft) And (n <= Count)
                    B2 = InputByte()
                    B1 = InputByte()
                    Result = Result & ChrW(ConstructInt16(B2, B1))
                    n = n + 1
                Loop
                
            Case StreamCharTypeASCII
                CharsLeft = BytesLeft       'The number of chars left = the number of bytes
                n = 1
                Do While (n <= CharsLeft) And (n <= Count)
                    B1 = InputByte()
                    Result = Result & ChrW(B1)
                    n = n + 1
                Loop
        End Select
        
        '==========================
        'Rewind - if option is true
        '==========================
        If Not Advance Then
            Seek m_FileNumber, OrigPos
        End If
    Else
        Result = ""        'File closed!!!!
    End If
           
    '========================================
    'Close the stream if end of file reached
    '========================================
    If BytesLeft = 0 Then
        CloseStream
    ElseIf VBA.EOF(m_FileNumber) Then
        CloseStream
    End If
            
    FileReadChars = Result
End Function




Private Sub FileWriteChars(Chars As String)
    Dim B1 As Byte, B2 As Byte, Code As Integer, n As Long
            
    If m_IsFileOpen And m_StreamCanWrite Then
        '==========================
        'Read from the file
        '==========================
        Select Case m_CharType
            Case StreamCharTypeUnicodeLE         'Little Endian - Intel
                For n = 1 To Len(Chars)
                    Code = AscW(Mid(Chars, n, 1))
                    DeconstructInt16 Code, B2, B1
                    
                    OutputByte B1
                    OutputByte B2
                Next
                                
            Case StreamCharTypeUnicodeBE         'Big Endian - Motorola
                For n = 1 To Len(Chars)
                    Code = AscW(Mid(Chars, n, 1))
                    DeconstructInt16 Code, B2, B1
                    
                    OutputByte B2
                    OutputByte B1
                Next
                
            Case StreamCharTypeASCII
                For n = 1 To Len(Chars)
                    Code = AscW(Mid(Chars, n, 1))
                                        
                    If Code >= 0 And Code <= 255 Then
                        OutputByte CByte(Code)
                    Else
                        OutputByte 63  '?
                    End If
                Next
        End Select
    End If

End Sub





Private Function ConstructInt16(B2 As Byte, B1 As Byte) As Integer
    'Integer range: -32,768 to 32,767
    '65535 = FFFF = -1
    '2's complement: -1 --> NOT 1 + 1 --> FFFE + 1 --> FFFF
                       
    Dim Temp As Long, Result As Integer
            
    Temp = (B2 * 256) + B1
           
    If Temp > 32767 Then                'Overflow - turn into a negative number
        Result = (65535 - Temp) - 1
    Else                                'Positive or zero
        Result = Temp
    End If

    ConstructInt16 = Result
End Function

Private Sub DeconstructInt16(Value As Integer, ByRef B2 As Byte, ByRef B1 As Byte)
    B2 = (Value And &HFF00) / &H100
    B1 = (Value And &HFF)
End Sub
Public Function NextCharacter() As String
    'Get the next character in the stream, but DO NOT READ IT!
    Dim Result As String

    Select Case m_StreamTarget
        Case StreamTargetFile
            If m_IsFileOpen Then       'Read from file
                Result = FileReadChars(1, False)
            Else
                Result = ""           'File closed!!!!
            End If
    
        Case StreamTargetString
            Result = Left(m_Buffer, 1)

    End Select

    NextCharacter = Result
End Function


Property Get Text() As String
   
   If m_StreamTarget = StreamTargetString Then
      Text = m_Buffer
   Else
      Text = ""
   End If

End Property

Property Let Text(NewString As String)

   If m_StreamTarget = StreamTargetString Then
       m_Buffer = NewString
   End If

End Property

Private Sub Class_Initialize()
    m_Buffer = ""
    m_StreamCanRead = True
    m_StreamCanWrite = True
    m_StreamTarget = StreamTargetString
    m_CharType = StreamCharTypeASCII
    m_ErrCode = 0
End Sub
Public Function ReadLine() As String
    Dim EndReached As Boolean, ch As String
    Dim Result As String
    
    If m_StreamCanRead Then
        EndReached = False
        
        '====== Read characters until the next character is a 10 or 13
        Do Until EndReached Or EOF()
            ch = ReadText(1)
            If ch = Chr(10) Or ch = Chr(13) Then         'End char
                ch = NextCharacter()
                If ch = Chr(10) Or ch = Chr(13) Then     'Discard second of line-feed, carriage return pair
                    ReadText
                End If
                EndReached = True
            Else
                Result = Result & ch
            End If
        Loop
    End If
    
    ReadLine = Result
End Function

Private Sub Class_Terminate()

    If m_IsFileOpen Then
       CloseFile
    End If

End Sub




